% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/server_ggplot.R
\name{basic_plot}
\alias{basic_plot}
\title{Create a basic plot using ggplot}
\usage{
basic_plot(
  df,
  x,
  y,
  color,
  xlab_setting,
  ylab_setting,
  ggplot_settings = ggplot_basic_settings(),
  legend_position = "none",
  scale_y = NULL
)
}
\arguments{
\item{df}{A data frame containing the data to be plotted.}

\item{x}{A string specifying the column name to be used as the x-axis variable.}

\item{y}{A string specifying the column name to be used as the y-axis variable.}

\item{color}{A string specifying the column name to be used as the fill variable.}

\item{xlab_setting}{ggplot labels settings for x axes.}

\item{ylab_setting}{ggplot labels settings for y axes.}

\item{ggplot_settings}{Additional settings for the ggplot.}

\item{legend_position}{A string specifying the position of the legend.}

\item{scale_y}{Optional ggplot2 scale function to modify the y axis.}
}
\value{
A ggplot plot.
}
\description{
This function creates a basic plot with the help of ggplot.
}
\examples{
df <- data.frame(x_var = rnorm(100),
                 y_var = rnorm(100),
                 color_var = sample(c("Red", "Blue"),
                 100,
                 replace = TRUE))
xlab_setting <- ggplot2::xlab("x label")
ylab_setting <- ggplot2::ylab("y label")
ggplot_instellingen <- ggplot2::geom_point()
scale_y <- ggplot2::scale_y_continuous()
basic_plot(df, "x_var", "y_var", "color_var", xlab_setting,
           ylab_setting, ggplot_instellingen, "none", scale_y)
}
