% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rquery_treatment.R
\name{rquery_prepare}
\alias{rquery_prepare}
\alias{materialize_treated}
\title{Materialize a treated data frame remotely.}
\usage{
rquery_prepare(
  db,
  rqplan,
  data_source,
  result_table_name,
  ...,
  extracols = NULL,
  temporary = FALSE,
  overwrite = TRUE,
  attempt_nan_inf_mapping = FALSE,
  col_sample = NULL,
  return_ops = FALSE
)

materialize_treated(
  db,
  rqplan,
  data_source,
  result_table_name,
  ...,
  extracols = NULL,
  temporary = FALSE,
  overwrite = TRUE,
  attempt_nan_inf_mapping = FALSE,
  col_sample = NULL,
  return_ops = FALSE
)
}
\arguments{
\item{db}{a db handle.}

\item{rqplan}{an query plan produced by as_rquery_plan().}

\item{data_source}{relop, data source (usually a relop_table_source).}

\item{result_table_name}{character, table name to land result in}

\item{...}{force later arguments to bind by name.}

\item{extracols}{extra columns to copy.}

\item{temporary}{logical, if TRUE try to make result temporary.}

\item{overwrite}{logical, if TRUE try to overwrite result.}

\item{attempt_nan_inf_mapping}{logical, if TRUE attempt to map NaN and Infnity to NA/NULL (goot on PostgreSQL, not on Spark).}

\item{col_sample}{sample of data to determine column types.}

\item{return_ops}{logical, if TRUE return operator tree instead of materializing.}
}
\value{
description of treated table.
}
\description{
Materialize a treated data frame remotely.
}
\section{Functions}{
\itemize{
\item \code{materialize_treated()}: old name for rquery_prepare function

}}
\seealso{
\code{\link{as_rquery_plan}}, \code{\link{rqdatatable_prepare}}
}
