% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EC_functions.R
\name{bin_calculate}
\alias{bin_calculate}
\title{Get bin averages for VPR and CTD data}
\usage{
bin_calculate(data, binSize = 1, imageVolume, rev = FALSE)
}
\arguments{
\item{data}{ctd data frame object including scan, salinity, temperature,
depth, conductivity, time, fluor_ref, turbidity_ref, turbidity_mv,
altitude, cast_id, n_roi}

\item{binSize}{the height of bins over which to average, default is 1 metre}

\item{imageVolume}{the volume of VPR images used for calculating concentrations (mm^3)}

\item{rev}{logical value, if TRUE, binning will begin at bottom of each cast,
this controls data loss due to uneven binning over depth. If bins begin at
bottom, small amounts of data may be lost at the surface of each cast, if
binning begins at surface (rev = FALSE), small amounts of data may be lost
at bottom of each cast}
}
\description{
Bins CTD data for an individual cast to avoid depth averaging across tow-yo's
}
\details{
Image volume calculations can change based on optical setting of VPR as well as autodeck setting used to process images
For IML2018051 (S2) image volume was calculated as 108155 mm^3 by seascan (6.6 cubic inches)
For COR2019002 S2 image volume was calculated as 83663 mm^3 and S3 image volume was calculated as 366082 mm^3.
Used internally ( \code{\link{bin_cast}} ) after \code{\link{ctd_cast}} on a single ascending or descending section of VPR cast
}
\note{
binSize should be carefully considered for best results

Depth is used for calculations! Please ensure depth is included in data frame using \link[oce]{swDepth}
}
\author{
E. Chisholm, K. Sorochan
}
