% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visOmopTable.R
\name{visOmopTable}
\alias{visOmopTable}
\title{Format a \verb{<summarised_result>} object into a gt, flextable, or tibble object}
\usage{
visOmopTable(
  result,
  estimateName = character(),
  header = character(),
  settingsColumn = character(),
  groupColumn = character(),
  rename = character(),
  type = "gt",
  hide = character(),
  columnOrder = character(),
  showMinCellCount = TRUE,
  .options = list(),
  settingsColumns = lifecycle::deprecated()
)
}
\arguments{
\item{result}{A \verb{<summarised_result>} object.}

\item{estimateName}{A named list of estimate names to join, sorted by
computation order. Use \verb{<...>} to indicate estimate names.}

\item{header}{A vector specifying the elements to include in the header.
The order of elements matters, with the first being the topmost header.
The input vector elements can be:
\enumerate{
\item Column names from the split summarised result generated by \code{splitAll()}
\item Settings specified in the \code{settings} argument
\item \code{group}, \code{strata}, \code{additional}, \code{variable}, \code{estimate}, and/or \code{settings}
to refer to all columns within these groups
\item Any other input to create overall header labels at the specified location.
}}

\item{settingsColumn}{A character vector with the names of settings to
include in the table.}

\item{groupColumn}{Columns to use as group labels. By default, the name of the
new group will be the tidy* column names separated by ";". To specify a custom
group name, use a named list such as:
list("newGroupName" = c("variable_name", "variable_level")).

*tidy: The tidy format applied to column names replaces "_" with a space and
converts to sentence case. Use \code{rename} to customize specific column names.}

\item{rename}{A named vector to customize column names, e.g.,
c("Database name" = "cdm_name"). The function renames all column names
not specified here into a tidy* format.}

\item{type}{The desired format of the output table. See \code{tableType()} for
allowed options.}

\item{hide}{Columns to drop from the output table. By default, \code{result_id} and
\code{estimate_type} are always dropped.}

\item{columnOrder}{Character vector establishing the position of the columns
in the formatted table. Columns in either header, groupColumn, or hide will
be ignored.}

\item{showMinCellCount}{If \code{TRUE}, suppressed estimates will be indicated with
"<\{min_cell_count\}", otherwise, the default \code{na} defined in \code{.options} will be
used.}

\item{.options}{A named list with additional formatting options.
\code{visOmopResults::tableOptions()} shows allowed arguments and their default values.}

\item{settingsColumns}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}
}
\value{
A tibble, gt, or flextable object.
}
\description{
This function combines the functionalities of \code{formatEstimateValue()},
\code{estimateName()}, \code{formatHeader()}, and \code{formatTable()}
into a single function specifically for \verb{<summarised_result>} objects.
}
\examples{
result <- mockSummarisedResult()
result |>
  visOmopTable(
    estimateName = c("N\%" = "<count> (<percentage>)",
                     "N" = "<count>",
                     "Mean (SD)" = "<mean> (<sd>)"),
    header = c("group"),
    rename = c("Database name" = "cdm_name"),
    groupColumn = strataColumns(result)
  )
}
