% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plottingThemes.R
\name{themeVisOmop}
\alias{themeVisOmop}
\title{Apply visOmopResults default styling to a ggplot}
\usage{
themeVisOmop(fontsizeRef = 13, legendPosition = "right")
}
\arguments{
\item{fontsizeRef}{An integer to use as reference when adjusting label
fontsize.}

\item{legendPosition}{If there is a legend, where should it go? Options are
the same as for ggplot. By default it is in the right side.}
}
\description{
Apply visOmopResults default styling to a ggplot
}
\examples{
\donttest{
result <- mockSummarisedResult() |> dplyr::filter(variable_name == "age")

barPlot(
  result = result,
  x = "cohort_name",
  y = "mean",
  facet = c("age_group", "sex"),
  colour = "sex") +
  themeVisOmop()
}
}
