library(violinplotter)
# ### local test
# list_sources = system("ls *.R", intern=TRUE)
# for (f in list_sources) {source(f)}
x1 = rep(rep(rep(c(1:5), each=5), times=5), times=5)
x2 = rep(rep(letters[6:10], each=5*5), times=5)
x3 = rep(letters[11:15], each=5*5*5)
y = rep(1:5, each=5*5*5) + rnorm(rep(1:5, each=5), length(x1)) ### x3 is the variable affecting y (see each=5*5*5)
data = data.frame(x1, x2, x3, y)
OUT_1 = violinplotter(formula=y ~ x1 + x2 + x3 + (x2:x3), data=data, ALPHA=0.05)
OUT_2 = violinplotter(formula=y ~ x1 + x2 + x3 + (x2:x3), data=data, ALPHA=0.001)
OUT_3 = violinplotter(formula=log(y) ~ exp(x1) + x2 + x3 + (x2:x3), data=data, ALPHA=0.001)
OUT_4 = violinplotter(formula=y ~ x1 + x2 + x3 + (x2:x3), data=data, CATEGORICAL=c(F,T,T,T), LOGX=c(T,F,F,F), LOGX_BASE=c(2,1,1,1), REGRESS=c(T,F,F,F))
OUT_5 = violinplotter(formula=y ~ x1 + x2 + x3, data=data, MANN_WHITNEY=FALSE, HSD=TRUE, SHOW_MEANS=TRUE, SHOW_SAMPLE_SIZE=TRUE)
OUT_6 = violinplotter(formula=y ~ x1 + x2 + x3, data=data, MANN_WHITNEY=TRUE, HSD=FALSE, SHOW_MEANS=TRUE)
