% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/utility.R,
%   R/VirtualArray-xattrib.R, R/XArray-xattrib.R, R/RasterArray-xattrib.R
\name{nlayers}
\alias{nlayers}
\alias{nlayers,list-method}
\alias{nlayers,SpatRaster-method}
\alias{length,VirtualArray-method}
\alias{nlayers,XArray-method}
\alias{nlayers,RasterArray-method}
\title{Number of elements or layers in a '\code{\link[via:XArray-class]{VirtualArray}}'-derived class object}
\usage{
nlayers(x)

\S4method{nlayers}{list}(x)

\S4method{nlayers}{SpatRaster}(x)

\S4method{length}{VirtualArray}(x)

\S4method{nlayers}{XArray}(x)

\S4method{nlayers}{RasterArray}(x)
}
\arguments{
\item{x}{a \code{\link[via:XArray-class]{VirtualArray}}-derived class object.}
}
\value{
A \code{numeric} value.
}
\description{
Function to return the length of the array in which elements are organized.
}
\details{
The \code{length()} function returns the number elements that should be present based on the array structure itself, and not the total number of values stored in the object. As the object can contain missing values, the number of actual layers can be queried with \code{\link{nlayers}}.
}
\examples{
ex <- rastex()
# omit third element
ex[3] <- NA
# number of elements in the RasterArray
length(ex)
# remaining number values in the stack 
length(ex@stack)
# the number of remaining layers in the RasterArray
nlayers(ex)

}
