% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Emissions.R
\name{Emissions}
\alias{Emissions}
\alias{print.Emissions}
\alias{summary.Emissions}
\alias{plot.Emissions}
\title{Construction function for class "Emissions"}
\usage{
Emissions(x, mass = "g", time, ...)

\method{print}{Emissions}(x, ...)

\method{summary}{Emissions}(object, ...)

\method{plot}{Emissions}(
  x,
  pal = "colo_angelafaye_Coloured_sky_in",
  rev = FALSE,
  fig1 = c(0, 0.8, 0, 0.8),
  fig2 = c(0, 0.8, 0.55, 1),
  fig3 = c(0.7, 1, 0, 0.8),
  mai1 = c(0.2, 0.82, 0.82, 0.42),
  mai2 = c(1.3, 0.82, 0.82, 0.42),
  mai3 = c(0.7, 0.72, 0.82, 0.42),
  main = NULL,
  bias = 1.5,
  ...
)
}
\arguments{
\item{x}{Object with class "data.frame", "matrix" or "numeric"}

\item{mass}{Character to be the time units as numerator, default "g" for grams}

\item{time}{Character to be the time units as denominator, eg "h"}

\item{...}{ignored}

\item{object}{object with class "Emissions"}

\item{pal}{Palette of colors available or the number of the position}

\item{rev}{Logical; to internally revert order of rgb color vectors.}

\item{fig1}{par parameters for fig, \code{\link{par}}.}

\item{fig2}{par parameters for fig, \code{\link{par}}.}

\item{fig3}{par parameters for fig, \code{\link{par}}.}

\item{mai1}{par parameters for mai, \code{\link{par}}.}

\item{mai2}{par parameters for mai, \code{\link{par}}.}

\item{mai3}{par parameters for mai, \code{\link{par}}.}

\item{main}{title of plot}

\item{bias}{positive number. Higher values give more widely spaced colors at the high end.}
}
\value{
Objects of class "Emissions" or "units"
}
\description{
\code{Emissions} returns a tranformed object with class "Emissions".
The type of objects supported are of classes "matrix", "data.frame" and
"numeric". If the class of the object is "matrix" this function returns a
dataframe.
}
\examples{
\dontrun{
data(net)
data(pc_profile)
data(fe2015)
data(fkm)
PC_G <- c(33491,22340,24818,31808,46458,28574,24856,28972,37818,49050,87923,
          133833,138441,142682,171029,151048,115228,98664,126444,101027,
          84771,55864,36306,21079,20138,17439, 7854,2215,656,1262,476,512,
          1181, 4991, 3711, 5653, 7039, 5839, 4257,3824, 3068)
veh <- data.frame(PC_G = PC_G)
pc1 <- my_age(x = net$ldv, y = PC_G, name = "PC")
pcw <- temp_fact(net$ldv+net$hdv, pc_profile)
speed <- netspeed(pcw, net$ps, net$ffs, net$capacity, net$lkm, alpha = 1)
pckm <- units::as_units(fkm[[1]](1:24), "km"); pckma <- cumsum(pckm)
cod1 <- emis_det(po = "CO", cc = 1000, eu = "III", km = pckma[1:11])
cod2 <- emis_det(po = "CO", cc = 1000, eu = "I", km = pckma[12:24])
#vehicles newer than pre-euro
co1 <- fe2015[fe2015$Pollutant=="CO", ] #24 obs!!!
cod <- c(co1$PC_G[1:24]*c(cod1,cod2),co1$PC_G[25:nrow(co1)])
lef <- ef_ldv_scaled(co1, cod, v = "PC",  cc = "<=1400",
                     f = "G", p = "CO", eu=co1$Euro_LDV)
E_CO <- emis(veh = pc1,lkm = net$lkm, ef = lef, speed = speed, agemax = 41,
             profile = pc_profile)
dim(E_CO) # streets x vehicle categories x hours x days
class(E_CO)
plot(E_CO)
####
Emissions(1)
Emissions(1, time = "h")
}
}
