% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_project.R
\name{get_project}
\alias{get_project}
\title{Download vein project}
\usage{
get_project(directory, case = "brasil")
}
\arguments{
\item{directory}{Character; Path to an existing or a new directory to be created.
It needs absolute path.}

\item{case}{Character; One of  of the following:
\tabular{llll}{
  \strong{case}       \tab \strong{Description}\tab  \strong{EF} \tab \strong{Outputs}   \cr
  brazil or brazil_bu or brasil or brasil_bu\tab Bottom-up \tab CETESB \tab  .rds       \cr
  emislacovid         \tab Bottom-up March 2020\tab CETESB \tab  .rds\cr
  brazil_bu_csvgz     \tab Bottom-up \tab CETESB \tab  .csv.gz    \cr
  brazil_bu_csv       \tab Bottom-up. Faster but heavier\tab CETESB\tab  .csv  \cr
  brazil_bu_cb05      \tab Bottom-up CB05\tab CETESB\tab  .rds       \cr
}}
}
\description{
\code{\link{get_project}} downloads a project for running vein.
The projects are available on Github.com/atmoschem/vein/projects
}
\note{
default case can be any of "brasil", "brazil", "brazil_bu", "brasil_bu", they are
the same
}
\examples{
\dontrun{
#do not run
get_project("awesomecity")
}

}
