% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emis_order.R
\name{emis_order}
\alias{emis_order}
\alias{weekly}
\title{Re-order the emission to match specific hours and days}
\format{Emissions}
\usage{
emis_order(EMISSION, start = "mon", hours = 168, utc, verbose = TRUE)
}
\arguments{
\item{EMISSION}{one of the following:

1) GriddedEmissionsArray or array with characteristics of GriddedEmissionsArray
2) Spatial object of class "Spatial". Columns are hourly emissions.
3) Spatial Object of class "sf". Columns are hourly emissions.
4) "data.frame", "matrix" or "Emissions". Columns are hourly emissions.}

\item{start}{Date or the start weekday or first 3 letters}

\item{hours}{Numeric; number of hours needed to the simualation}

\item{utc}{Integer; transform local into UTC emissions. For instance,
utc = -3 means that the first hour of emissions is at 21:00 of the previous
day.}

\item{verbose}{Logical; display additional information}
}
\value{
GriddedEmissionsArray, sf or data.frame, depending on the class of
EMISSION
}
\description{
returns the emission array matching with corresponding weekdays and with
the desired number of hours, recycling or droping hours from the emission array. For
instance, if your emissions starts Monday at 00:00 and cover 168 hours, and you
want to reorder them to start saturday you with a total a new length of hours
of 241, you must :emis_order(EMISSION, as.Date("2016-04-06"), 241)
}
\note{
This function assumes that the emissions have hours with length of
factor of 24, e.g: 24 hours, 24*2 hours etc. Then, it re-order the emissions
by the hours of estimations to match another length of emissions. For
instance, if the input covers 168 hours and it is desired an object of 241
hours that start saturday, this function can do that. It is useful when you
are going to start a air quality simulation for specific periods of time.
}
\examples{
\dontrun{
wCO <- emis_order(CO, start = "sat", hours = 24, verbose = TRUE)
wCO <- emis_order(CO, start = as.Date("2016-04-06"), hours = 241, verbose = TRUE)
}

}
\author{
Daniel Schuch& Sergio Ibarra
}
