% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec-version.R
\name{vw_spec_version}
\alias{vw_spec_version}
\title{Determine vegaspec version}
\usage{
vw_spec_version(spec)
}
\arguments{
\item{spec}{An object to be coerced to \code{vegaspec}, a Vega/Vega-Lite specification}
}
\value{
\code{list} with elements \code{library}, \code{version}
}
\description{
Use this function to determine the \code{library} and \code{version} of a \code{vegaspec}.
}
\details{
Returns a list with two elements:

\describe{
\item{\code{library}}{\code{character}, either \code{"vega"} or \code{"vega_lite"}}
\item{\code{version}}{\code{character}, version tag}
}
}
\examples{
  vw_spec_version(spec_mtcars)
\dontrun{
  # requires nodejs to be installed
  vw_spec_version(vw_to_vega(spec_mtcars))
}
}
