% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_comp.R
\name{meta.lc.prop.ps}
\alias{meta.lc.prop.ps}
\title{Confidence interval for a linear contrast of proportion differences in
paired-samples studies}
\usage{
meta.lc.prop.ps(alpha, f11, f12, f21, f22, v)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{f11}{vector of frequency counts in cell 1,1}

\item{f12}{vector of frequency counts in cell 1,2}

\item{f21}{vector of frequency counts in cell 2,1}

\item{f22}{vector of frequency counts in cell 2,2}

\item{v}{vector of contrast coefficients}
}
\value{
Returns 1-row matrix with the following columns:
\itemize{
\item Estimate - estimated linear contrast
\item SE - standard error
\item LL - lower limit of the adjusted Wald confidence interval
\item UL - upper limit of the adjusted Wald confidence interval
}
}
\description{
Computes the estimate, standard error, and adjusted Wald confidence interval
for a linear contrast of paired-samples proportion differences from two or
more studies.
}
\examples{
f11 <- c(17, 28, 19)
f12 <- c(43, 56, 49)
f21 <- c(3, 5, 5)
f22 <- c(37, 54, 39)
v <- c(.5, .5, -1)
meta.lc.prop.ps(.05, f11, f12, f21, f22, v)

# Should return:
#              Estimate         SE         LL       UL
#  Contrast -0.01436285 0.06511285 -0.1419817 0.113256


}
\references{
\insertRef{Bonett2014}{vcmeta}
}
