% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_se.R
\name{se.cor}
\alias{se.cor}
\title{Computes the standard error for a Pearson or partial correlation}
\usage{
se.cor(cor, q, n)
}
\arguments{
\item{cor}{sample Pearson or partial correlation}

\item{q}{number of control variables (0 for Pearson)}

\item{n}{sample size}
}
\value{
Returns a one-row matrix:
\itemize{
\item Estimate - estimate of Pearson or partial correlation
\item SE - standard error
}
}
\description{
This function can be used to compute the standard error of a
Pearson or partial correlation using the sample correlation, sample
size, and number of control variables. The effect size estimate and
standard error output from this function can be used as input in the
\link[vcmeta]{meta.ave.gen}, \link[vcmeta]{meta.lc.gen}, and
\link[vcmeta]{meta.lm.gen} functions in applications where a combination
of different types of correlations are used in the meta-analysis.
}
\examples{
se.cor(.40, 0, 55)

# Should return: 
#              Estimate       SE
# Correlation:      0.4 0.116487


}
\references{
\insertRef{Bonett2008a}{vcmeta}
}
