% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_model.R
\name{meta.lm.cor}
\alias{meta.lm.cor}
\title{Meta-regression analysis for Pearson or partial correlations}
\usage{
meta.lm.cor(alpha, n, cor, q, X)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{n}{vector of sample sizes}

\item{cor}{vector of Pearson or partial correlations}

\item{q}{number of control variables}

\item{X}{matrix of predictor values}
}
\value{
Returns a matrix.  The first row is for the intercept with one additional
row per predictor.  The matrix has the following columns:
\itemize{
\item Estimate - OLS estimate
\item SE - Standard error
\item z - z-value
\item p - p-value
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
This function estimates the intercept and slope coefficients in a
meta-regression model where the dependent variable is a Fisher-
transformed Pearson or partial correlation.The estimates are OLS
estimates with standard errors that accommodate residual heteroscedasticity.
The correlations are Fisher-transformed and hence the parameter estimates
do not have a simple interpretation. However, the hypothesis test results
can be used to decide if a population slope is either positive or negative.
}
\examples{

n <- c(55, 190, 65, 35)
cor <- c(.40, .65, .60, .45)
q <- 0
x1 <- c(18, 25, 23, 19)
X <- matrix(x1, 4, 1)
meta.lm.cor(.05, n, cor, q, X)

# Should return: 
#       Estimate         SE         z     p           LL         UL
# b0 -0.47832153 0.48631509 -0.983563 0.325 -1.431481595 0.47483852
# b1  0.05047154 0.02128496  2.371231 0.018  0.008753794 0.09218929


}
