## convenience function for interfacing
## HCL colors as implemented in colorspace
hcl2hex <- function(h = 0, c = 35, l = 85, gamma = 2.2, fixup = TRUE)
{
  hex(polarLUV(l, c, h), gamma = gamma, fixup = fixup)
}
## FIXME:
## could do something similar for HSV, but this would not
## equivalent to hsv()!

## color palettes

rainbow_hcl <- function(n, c = 50, l = 70, start = 0, end = 360*(n-1)/n, ...)
{
  if(n > 0) hcl2hex(seq(start, end, length = n), c = c, l = l, ...)
    else character(0)
}

diverge_hcl <- function(n, h = c(260, 0), c = 80, l = c(30, 90), power = 1.5, ...)
{
  if(n < 1) return(character(0))
  h <- rep(h, length.out = 2)
  c <- c[1]
  l <- rep(l, length.out = 2)
  power <- rep(power, length.out = 2)
  rval <- seq(1, -1, length = n)
  rval <- hcl2hex(h = ifelse(rval > 0, h[1], h[2]),
                  c = c * abs(rval)^power[1],
                  l = l[2] - diff(l) * abs(rval)^power[2],
                  ...)
  return(rval)
}

diverge_hsv <- function(n, h = c(2/3, 0), s = 1, v = 1, power = 1, ...)
{
  if(n < 1) return(character(0))
  h <- rep(h, length.out = 2)
  s <- s[1]
  v <- v[1]
  power <- power[1]
  rval <- seq(-s, s, length = n)
  rval <- hsv(h = ifelse(rval > 0, h[2], h[1]), s = abs(rval)^power, v = v, ...)
  return(rval)
}

sequential_hcl <- function(n, h = 260, c. = c(80, 0), l = c(30, 90), power = 1.5, ...)
{
  if(n < 1) return(character(0))
  c <- rep(c., length.out = 2)
  l <- rep(l, length.out = 2)
  power <- rep(power, length.out = 2)
  rval <- seq(1, 0, length = n)
  rval <- hcl2hex(h = h[1],
                  c = c[2] - diff(c) * rval^power[1],
                  l = l[2] - diff(l) * rval^power[2],
                  ...)
  return(rval)
}

heat_hcl <- function(n, h = c(0, 90), c. = c(100, 30), l = c(50, 90),
  power = c(1/5, 1), ...)
{
  if(n < 1) return(character(0))
  h <- rep(h, length.out = 2)
  c <- rep(c., length.out = 2)
  l <- rep(l, length.out = 2)
  power <- rep(power, length.out = 2)
  rval <- seq(1, 0, length = n)
  rval <- hcl2hex(h = h[2] - diff(h) * rval,
                  c = c[2] - diff(c) * rval^power[1],
                  l = l[2] - diff(l) * rval^power[2],
                  ...)
  return(rval)
}

terrain_hcl <- function(n, h = c(130, 0), c. = c(80, 0), l = c(60, 95), power = c(1/10, 1), ...)
  heat_hcl(n, h = h, c. = c., l = l, power = power, ...)
