% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FreeSASA.R
\name{FreeSASAcheck}
\alias{FreeSASAcheck}
\title{FreeSASA Check}
\usage{
FreeSASAcheck()
}
\value{
When \href{http://freesasa.github.io}{FreeSASA} is correctly installed
the current version and citation are returned to the user: \cr\preformatted{FreeSASA 2.0
License: MIT <http://opensource.org/licenses/MIT>
If you use this program for research, please cite:
  Simon Mitternacht (2016) FreeSASA: An open source C
  library for solvent accessible surface area calculations.
F1000Research 5:189.
}

When \href{http://freesasa.github.io}{FreeSASA} is \emph{\strong{NOT}}
correctly installed the following are returned to the user:\preformatted{Error in FreeSASAcheck() :
Uh-oh!!
Please make sure FreeSASA is correctly installed! Please visit
(http://freesasa.github.io) for
instructions specific to your operating system.
}
}
\description{
Determines if FreeSASA is (correctly) installed.
}
\details{
Because \href{http://freesasa.github.io}{FreeSASA} is
\emph{\strong{NOT}} included with \link{vanddraabe} it
is important to ensure the application has been installed and was correctly
compiled.
}
\examples{
\dontrun{
  # Result for correct installation
  FreeSASAcheck()
  # FreeSASA 2.0
  # License: MIT <http://opensource.org/licenses/MIT>
  # If you use this program for research, please cite:
  #   Simon Mitternacht (2016) FreeSASA: An open source C
  #   library for solvent accessible surface area calculations.
  #   F1000Research 5:189.
  #
  # Report bugs to <https://github.com/mittinatten/freesasa/issues>
  # Home page: <http://freesasa.github.io>
  #
  # Congratulations! FreeSASA is correctly installed!
  #
  # Result for incorrect installation
  FreeSASAcheck()
  # Error:
  # Uh-oh!!
  # Please make sure FreeSASA is correctly installed. Please visit
  # http://freesasa.github.io for instructions specific to your operating
  # system.
}

}
\references{
Simon Mitternacht. FreeSASA: An open source C library for solvent
accessible surface area calculations [version 1; referees: 2 approved].
\emph{F1000Research}, 2016, \strong{5}:189
\href{http://doi.org/10.12688/f1000research.7931.1}{DOI: 10.12688/f1000research.7931.1}
\href{https://www.ncbi.nlm.nih.gov/pmc/articles/PMC4776673/}{PMCID: PMC4776673}
\href{http://freesasa.github.io}{FreeSASA}

[version 1; referees: 2 approved]: R:version%201;%20referees:%202%20approved%5C
[DOI: 10.12688/f1000research.7931.1]: R:DOI:%2010.12688/f1000research.7931.1
[PMCID: PMC4776673]: R:PMCID:%20PMC4776673
[FreeSASA]: R:FreeSASA
}
\seealso{
Other "vanddraabe utilities": \code{\link{ConservedWaterStats}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
