% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/va_products.R
\docType{class}
\name{va_product}
\alias{va_product}
\title{Generic Variable Annuity  product class}
\format{\code{\link{R6Class}} object.}
\usage{
va_product
}
\value{
Object of \code{\link{R6Class}}
}
\description{
Class providing an interface for a generic VA product object.
This class shouldn't be instantiated but used as base class for
implementing  products with contract riders such as GMAB, GMIB, etc.
It supports a simple state-dependent fee structure with a single barrier.\cr
See \bold{References} for a description of variable annuities life
insurance products, their guarantees and fee structures.
}
\section{Methods}{

 \describe{
  \item{\code{new}}{Constructor method with arguments:
   \describe{
    \item{\code{payoff}}{\code{payoff} object of the GMAB guarantee}
    \item{\code{t0}}{\code{\link{timeDate}} object with
    the issue date of the contract}
    \item{\code{t}}{\code{timeDate} object with the end date of the
    accumulation period}
    \item{\code{t1}}{\code{timeDate} object with the end date of the
     life benefit payment}
    \item{\code{age}}{\code{numeric} positive scalar with the age
     of the policyholder}
    \item{\code{fee}}{\code{\link{constant_parameters}} object with
     the fee}
    \item{\code{barrier}}{\code{numeric} positive scalar with the
     state-dependent fee barrier}
    \item{\code{penalty}}{\code{\link{penalty_class}} object with the
    penalty}
   }
  }
  \item{\code{get_times}}{get method for the product time-line.
   Returns a \code{\link{timeDate}} object}
  \item{\code{get_age}}{get method for the age of the insured}
  \item{\code{set_age}}{set method for the age of the insured}
  \item{\code{get_barrier}}{get method for the state-dependent fee barrier.
   Returns a positive scalar with the barrier}
  \item{\code{set_barrier}}{set method for the state-dependent fee barrier.
    Argument must be a positive scalar.}
  \item{\code{set_penalty_object}}{the argument \code{penalty} is a
  \code{\link{penalty_class}} object which is stored in a private field.}
  \item{\code{get_penalty_object}}{gets the \code{\link{penalty_class}} object.}
  \item{\code{set_penalty}}{set method for the penalty applied in case of
   surrender. The argument must be a scalar between 0 and 1.}
  \item{\code{get_penalty}}{get method for the surrender penalties. It can be
  a scalar between 0 and 1 in case the penalty is constant or a numeric vector
  in case the penalty varies with time.}
  \item{\code{set_fee}}{set method for the contract fee. The argument is
     a \code{\link{constant_parameters}} object with the fee.}
  \item{\code{set_payoff}}{set method for the \code{\link{payoff_guarantee}}
   object.}
  \item{\code{survival_benefit_times}}{returns a \code{numeric} vector with
   the survival benefit time indexes.}
  \item{\code{surrender_times}}{returns a \code{numeric} vector with the
   surrender time indexes. Takes as argument a string with the frequency
   of the decision if surrendering the contract,  e.g. "3m"
   corresponds to a surrender decision taken every 3 months.}
 \item{\code{times_in_yrs}}{returns the product time-line in
   fraction of year}
  \item{\code{cash_flows}}{returns a \code{numeric} vector with the
   cash flows of the product. It takes as argument \code{spot_values} a
   \code{numeric} vector which holds the values of the underlying fund this
   method will calculate the cash flows from}
  \item{\code{survival_benefit}}{Returns a numeric scalar corresponding to
   the survival benefit.
   The arguments are \code{spot_values} vector which holds the values of
   the underlying fund and \code{t} the time index of the survival benefit.
   The function will return 0 if there's no survival benefit at the
   specified time}
  \item{\code{get_premium}}{Returns the premium as non negative scalar}
}
}

\references{
\enumerate{
\item{[BMOP2011]}{ \cite{Bacinello A.R., Millossovich P., Olivieri A.,
 Pitacco  E., "Variable annuities: a unifying valuation approach."
In: Insurance: Mathematics and Economics 49 (2011), pp. 285-297.
}}
\item{[BHM2014]}{ \cite{Bernard C., Hardy M. and Mackay A. "State-dependent
fees for variable annuity guarantees." In: Astin Bulletin 44 (2014),
pp. 559-585.}}
}
}
\keyword{datasets}
