% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{runValse}
\alias{runValse}
\title{runValse}
\usage{
runValse(
  X,
  Y,
  procedure = "LassoMLE",
  selecMod = "DDSE",
  gamma = 1,
  mini = 10,
  maxi = 50,
  eps = 1e-04,
  kmin = 2,
  kmax = 3,
  rank.min = 1,
  rank.max = 5,
  ncores_outer = 1,
  ncores_inner = 1,
  thresh = 1e-08,
  grid_lambda = numeric(0),
  size_coll_mod = 50,
  fast = TRUE,
  verbose = FALSE,
  plot = TRUE
)
}
\arguments{
\item{X}{matrix of covariates (of size n*p)}

\item{Y}{matrix of responses (of size n*m)}

\item{procedure}{among 'LassoMLE' or 'LassoRank'}

\item{selecMod}{method to select a model among 'DDSE', 'DJump', 'BIC' or 'AIC'}

\item{gamma}{integer for the power in the penaly, by default = 1}

\item{mini}{integer, minimum number of iterations in the EM algorithm, by default = 10}

\item{maxi}{integer, maximum number of iterations in the EM algorithm, by default = 100}

\item{eps}{real, threshold to say the EM algorithm converges, by default = 1e-4}

\item{kmin}{integer, minimum number of clusters, by default = 2}

\item{kmax}{integer, maximum number of clusters, by default = 10}

\item{rank.min}{integer, minimum rank in the low rank procedure, by default = 1}

\item{rank.max}{integer, maximum rank in the low rank procedure, by default = 5}

\item{ncores_outer}{Number of cores for the outer loop on k}

\item{ncores_inner}{Number of cores for the inner loop on lambda}

\item{thresh}{real, threshold to say a variable is relevant, by default = 1e-8}

\item{grid_lambda, }{a vector with regularization parameters if known, by default numeric(0)}

\item{size_coll_mod}{(Maximum) size of a collection of models, by default 50}

\item{fast}{TRUE to use compiled C code, FALSE for R code only}

\item{verbose}{TRUE to show some execution traces}

\item{plot}{TRUE to plot the selected models after run}
}
\value{
The selected model (except if the collection of models
has less than 11 models, the function returns the collection as it can not select one using Capushe)
}
\description{
Main function
}
\examples{
n = 50; m = 10; p = 5
beta = array(0, dim=c(p,m,2))
beta[,,1] = 1
beta[,,2] = 2
data = generateXY(n, c(0.4,0.6), rep(0,p), beta, diag(0.5, p), diag(0.5, m))
X = data$X
Y = data$Y
res = runValse(X, Y, kmax = 5, plot=FALSE)
X <- matrix(runif(100), nrow=50)
Y <- matrix(runif(100), nrow=50)
res = runValse(X, Y, plot=FALSE)

}
