% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rule.R, R/expressionset.R, R/confrontation.R
\name{names<-,rule,character-method}
\alias{names<-,rule,character-method}
\alias{names,expressionset-method}
\alias{names<-,expressionset,character-method}
\alias{names,confrontation-method}
\title{Extract or set names}
\usage{
\S4method{names}{rule,character}(x) <- value

\S4method{names}{expressionset}(x)

\S4method{names}{expressionset,character}(x) <- value

\S4method{names}{confrontation}(x)
}
\arguments{
\item{x}{An R object}

\item{value}{Value to set}
}
\value{
A \code{character} vector
}
\description{
Extract or set names

When setting names, \code{value}s are recycled and made unique with
\code{\link{make.names}}

Get names from \code{confrontation} object
}
\examples{

# retrieve properties
v <- validator(turnover > 0, staff.costs>0)

# number of rules in v:
length(v)

# per-rule
created(v)
origin(v)
names(v)

# set properties
names(v)[1] <- "p1"

label(v)[1] <- "turnover positive"
description(v)[1] <- "
According to the official definition,
only positive values can be considered
valid turnovers.
"

# short description is also printed:
v

# print all info for first rule
v[[1]]



# retrieve properties
v <- validator(turnover > 0, staff.costs>0)

# number of rules in v:
length(v)

# per-rule
created(v)
origin(v)
names(v)

# set properties
names(v)[1] <- "p1"

label(v)[1] <- "turnover positive"
description(v)[1] <- "
According to the official definition,
only positive values can be considered
valid turnovers.
"

# short description is also printed:
v

# print all info for first rule
v[[1]]


}
\seealso{
Other expressionset-methods: 
\code{\link{as.data.frame,expressionset-method}},
\code{\link{as.data.frame}()},
\code{\link{created}()},
\code{\link{description}()},
\code{\link{label}()},
\code{\link{meta}()},
\code{\link{origin}()},
\code{\link{plot,validator-method}},
\code{\link{summary}()},
\code{\link{variables}()},
\code{\link{voptions}()}

Other validation-methods: 
\code{\link{aggregate,validation-method}},
\code{\link{all,validation-method}},
\code{\link{any,validation-method}},
\code{\link{barplot,validation-method}},
\code{\link{check_that}()},
\code{\link{compare}()},
\code{\link{confront}()},
\code{\link{event}()},
\code{\link{plot,validation-method}},
\code{\link{sort,validation-method}},
\code{\link{summary}()},
\code{\link{validation-class}},
\code{\link{values}()}
}
\concept{expressionset-methods}
\concept{validation-methods}
