% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confrontation.R
\docType{methods}
\name{plot,validation-method}
\alias{plot,validation-method}
\title{Plot a validation object}
\usage{
\S4method{plot}{validation}(x, y, ...)
}
\arguments{
\item{x}{a confrontation object.}

\item{y}{not used}

\item{...}{passed to \code{barplot}}
}
\description{
The plot function for the confrontation object is identical to the \code{\link{barplot}} 
method.
}
\examples{
rules <- validator( r1 = staff.costs < total.costs
                  , r2 = turnover + other.rev == total.rev
                  , r3 = other.rev > 0
                  , r4 = total.rev > 0
                  , r5 = nace \%in\% c("A", "B")
                  )
plot(rules, cex=0.8, show_legend=TRUE)

data(retailers)
cf <- confront(retailers, rules)
plot(cf, main="Retailers check")
}
\seealso{
Other validation-methods: \code{\link{aggregate,validation-method}},
  \code{\link{all,validation-method}},
  \code{\link{any,validation-method}},
  \code{\link{barplot,validation-method}},
  \code{\link{check_that}}, \code{\link{compare}},
  \code{\link{confront}},
  \code{\link{sort,validation-method}},
  \code{\link{summary}}, \code{\link{validation-class}},
  \code{\link{values}}
}
