% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_vicc.R
\name{plot.vicc}
\alias{plot.vicc}
\title{Plot \code{vicc} Objects}
\usage{
\method{plot}{vicc}(x, type = "coef", ...)
}
\arguments{
\item{x}{An object of class \code{vicc}.}

\item{type}{Character string. Which parameters should be plotted? The options are
\code{ranef} and \code{coef} (the default).}

\item{...}{Currently ignored.}
}
\value{
A \code{ggplot} object.
}
\description{
Plot the group-specific coefficients or the random effects.
}
\examples{
\donttest{
# congruent trials
congruent <- subset(flanker, cond == 0)

# subset 25 from each group
dat <- congruent[unlist(tapply(1:nrow(congruent),
                            congruent$id,
                            head, 25)), ]

# fit model
fit <- vicc(y  = dat$rt,
            group = dat$id,
            iter = 250,
            burnin = 10,
            type =  "customary")

plts <- plot(fit)
}
}
