% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_learner.R
\name{mlpredict}
\alias{mlpredict}
\alias{mlpredict.C5.0}
\alias{mlpredict.J48}
\alias{mlpredict.SMO}
\alias{mlpredict.baseKNN}
\alias{mlpredict.default}
\alias{mlpredict.emptyModel}
\alias{mlpredict.majorityModel}
\alias{mlpredict.naiveBayes}
\alias{mlpredict.randomForest}
\alias{mlpredict.randomModel}
\alias{mlpredict.rpart}
\alias{mlpredict.svm}
\alias{mlpredict.xgb.Booster}
\title{Prediction transformation problems}
\usage{
mlpredict(model, newdata, ...)

\method{mlpredict}{default}(model, newdata, ...)

\method{mlpredict}{svm}(model, newdata, ...)

\method{mlpredict}{SMO}(model, newdata, ...)

\method{mlpredict}{J48}(model, newdata, ...)

\method{mlpredict}{C5.0}(model, newdata, ...)

\method{mlpredict}{rpart}(model, newdata, ...)

\method{mlpredict}{randomForest}(model, newdata, ...)

\method{mlpredict}{naiveBayes}(model, newdata, ...)

\method{mlpredict}{baseKNN}(model, newdata, ...)

\method{mlpredict}{xgb.Booster}(model, newdata, ...)

\method{mlpredict}{majorityModel}(model, newdata, ...)

\method{mlpredict}{randomModel}(model, newdata, ...)

\method{mlpredict}{emptyModel}(model, newdata, ...)
}
\arguments{
\item{model}{An object model returned by some mltrain method, its class
determine the name of this method.}

\item{newdata}{A data.frame with the new data to be predicted.}

\item{...}{Others arguments passed to the predict method.}
}
\value{
A matrix with the probabilities of each class value/example,
 where the rows are the examples and the columns the class values.
}
\description{
Base classifiers are used to build models to solve the the transformation
problems. To create a new base classifier, two steps are necessary:
\enumerate{
  \item Create a train method
  \item Create a prediction method
}
This section is about how to create the second step: a prediction method.
To create a new train method see \code{\link{mltrain}} documentation.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default S3 method

\item \code{svm}: SVM implementation (require \pkg{e1071} package to use)

\item \code{SMO}: SMO implementation (require \pkg{RWeka} package to use)

\item \code{J48}: J48 implementation (require \pkg{RWeka} package to use)

\item \code{C5.0}: C5.0 implementation (require \pkg{C50} package to use)

\item \code{rpart}: CART implementation (require \pkg{rpart} package)

\item \code{randomForest}: Random Forest (RF) implementation (require
\pkg{randomForest} package to use)

\item \code{naiveBayes}: Naive Bayes (NB) implementation (require
\pkg{e1071} package to use)

\item \code{baseKNN}: kNN implementation (require \pkg{kknn} package to use)

\item \code{xgb.Booster}: XGBoost implementation (require \pkg{xgboost} package)

\item \code{majorityModel}: Majority prediction

\item \code{randomModel}: Majority prediction

\item \code{emptyModel}: Empty model to fix the cases with few train examples
}}
\section{How to create a new prediction base method}{

Fist is necessary to know the class of model generate by the respective train
method, because this name determines the method name. It must start with
\code{'mlpredict.'}, followed by the model class name, e.g. a model with
class 'fooModel' must be called as \code{mlpredict.fooModel}.

After defined the name, you need to implement your prediction base method.
The model built on mltrain is available on \code{model} parameter and the
\code{newdata} is the data to be predict.

The return of this method must be a data.frame with two columns called
\code{"prediction"} and \code{"probability"}. The first column contains the
predicted classe and the second the probability/score/confidence of this
prediction. The rows represents the examples.
}
\examples{

# Create a method that predict always the first class
# The model must be of the class 'fooModel'
mlpredict.fooModel <- function (model, newdata, ...) {
   # Predict the first class with a random confidence
   data.frame(
     prediction = rep(model$classes[1], nrow(newdata)),
     probability = sapply(runif(nrow(newdata)), function (score) {
       max(score, 1 - score)
     }),
     row.names = rownames(newdata)
   )
}

\dontrun{
# Create a SVM predict method using the e1071 package (the class of SVM model
# from e1071 package is 'svm')
library(e1071)
mlpredict.svm <- function (dataset, newdata, ...) {
   result <- predict(model, newdata, probability = TRUE, ...)
   attr(result, 'probabilities')
}
}
}

