% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HigherOrderRiskPreferences.R
\name{find_optimal_lambda}
\alias{find_optimal_lambda}
\title{Finds an optimal penalty weight lambda given the parameters}
\usage{
find_optimal_lambda(
  xi,
  yi,
  lambda_max = 10000,
  n_penalty_dimensions = 1,
  penalty_order = 4,
  ndx = 20,
  deg = 6,
  cross_validation_mode = 0,
  grid_dim = 5
)
}
\arguments{
\item{xi}{a vector containing the certainty equivalents (x-values of utility points) for a given participant in each use case.}

\item{yi}{can be a vector or a matrix representing the corresponding utility values (y-values of utility points).}

\item{lambda_max}{maximum lambda used for computing the optimal lambda. The default value is 10000.}

\item{n_penalty_dimensions}{number of dimensions (i.e., derivatives) to penalize. Possible values are 1 or 2. The default value is 1.}

\item{penalty_order}{highest dimension (i.e., derivative) to penalize. Must be lower than deg.}

\item{ndx}{number of intervals to partition the distance between the lowest and highest x-values of the utility points.}

\item{deg}{degree of the B-spline basis. Determines the degree of the function to be estimated. If deg = 2, the estimated utility function will consist of quadratic functions.}

\item{cross_validation_mode}{determines which cross validation mode should be used. If 0, then the cross validation method is leave-one-third-out. If 1, then the cross validation method is a theoretical leave-one-out, i.e., based on a formula. The default value is 1.}

\item{grid_dim}{dimension of the search grid for the initial grid search before the actual optimization. Default value is 5.}
}
\value{
the optimal lambda for the given set of utility points and (possibly default) settings according to the specified cross validation method.
}
\description{
Finds an optimal penalty weight lambda given the parameters
}
\examples{
x <- c(0.0000000, 0.2819824, 0.3007812, 0.4375000, 0.5231934, 0.7784882, 0.8945312, 1.0000000)
y <- c(0.0000, 0.1250, 0.2500, 0.5000, 0.6250, 0.6875, 0.7500, 1.0000)
find_optimal_lambda(x, y)
}
