% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_pals.R
\docType{data}
\name{uni_freiburg_1}
\alias{uni_freiburg_1}
\title{Primary colors of the University of Freiburg}
\format{
An object of class \code{character} of length 7.
}
\source{
Color definitions are based on the new web style guide at 
\url{https://uni-freiburg.de/} 
(at \code{https://uni-freiburg.de/universitaet/corporate-design/} on 2023-01-01).
}
\usage{
uni_freiburg_1
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{uni_freiburg_1} provides a primary color palette 
of the \href{https://uni-freiburg.de/}{University of Freiburg}, Germany.
}
\details{
The primary color \code{Blau} (here: \code{uni_freiburg_1[2]}) is alternatively defined as 
\code{Pantone 7687C}, \code{RGB 52/74/154}, \code{HEX #344a9a}, or \code{CMYK 90/75/0/0}.

The gradient of \code{Blau} was created by mixing 
the primary color \code{uni_freiburg_0[2]} with \code{"white"}, 
as in \code{usecol(c(uni_freiburg_0[2], "white"), n = 6)[1:5]}. 

See \code{\link{uni_freiburg_0}} for the basic colors (without the \code{Blau} color gradient) 
and the \code{\link{ac}} and \code{\link{usecol}} functions for creating color gradients.
}
\examples{
uni_freiburg_1
seecol(uni_freiburg_1, main = "Primary color gradient of the University of Freiburg")
demopal(uni_freiburg_1, type = 1, main = "Primary color gradient of Freiburg University")

}
\seealso{
\code{\link{uni_freiburg_0}} for the basic colors of the University of Freiburg;
\code{\link{uni_freiburg_2}} for the secondary colors of the University of Freiburg;
\code{\link{seecol}} for viewing and comparing color palettes; 
\code{\link{usecol}} for using color palettes; 
\code{\link{simcol}} for finding similar colors; 
\code{\link{newpal}} for defining new color palettes; 
\code{\link{grepal}} for finding named colors.

Other contributed color palettes: 
\code{\link{caltech_pal_1}},
\code{\link{caltech_pal_2}},
\code{\link{caltech_pal_3}},
\code{\link{eth_pal_1}},
\code{\link{eth_pal_2}},
\code{\link{eth_pal_3}},
\code{\link{fu_pal_0}},
\code{\link{fu_pal_1}},
\code{\link{fu_pal_2}},
\code{\link{fu_pal_3}},
\code{\link{hu_pal_1}},
\code{\link{hu_pal_2}},
\code{\link{lmu_pal_1}},
\code{\link{lmu_pal_2}},
\code{\link{lmu_pal_3}},
\code{\link{mpg_pal}},
\code{\link{rpi_pal_1}},
\code{\link{rpi_pal_2}},
\code{\link{rpi_pal_3}},
\code{\link{rptu_pal}},
\code{\link{uni_bonn_1}},
\code{\link{uni_bonn_2}},
\code{\link{uni_freiburg_0}},
\code{\link{uni_freiburg_2}},
\code{\link{uni_freiburg_blue}},
\code{\link{uni_freiburg_br}},
\code{\link{uni_freiburg_grey}},
\code{\link{uni_freiburg_info}},
\code{\link{uni_goettingen_1}},
\code{\link{uni_goettingen_2}},
\code{\link{uni_goettingen_3}},
\code{\link{uni_hamburg_1}},
\code{\link{uni_hamburg_2}},
\code{\link{uni_jena_1}},
\code{\link{uni_jena_2}},
\code{\link{uni_kiel_1}},
\code{\link{uni_kiel_2}},
\code{\link{uni_koeln_1}},
\code{\link{uni_koeln_2}},
\code{\link{uni_konstanz_1}},
\code{\link{uni_konstanz_2}},
\code{\link{uni_mannheim_1}},
\code{\link{uni_mannheim_2}},
\code{\link{uni_princeton_0}},
\code{\link{uni_princeton_1}},
\code{\link{uni_princeton_2}},
\code{\link{uni_regensburg_1}},
\code{\link{uni_regensburg_2}},
\code{\link{uni_regensburg_3}},
\code{\link{uni_ulm_1}},
\code{\link{uni_ulm_2}}
}
\author{
\strong{unikn}, 2023-01-01.
}
\concept{contributed color palettes}
\keyword{datasets}
