% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_pals.R
\docType{data}
\name{caltech_pal_3}
\alias{caltech_pal_3}
\title{Primary and bright colors of Caltech}
\format{
An object of class \code{character} of length 8.
}
\source{
Color definitions are based on 
\url{https://identity.caltech.edu/colors}.
}
\usage{
caltech_pal_3
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{caltech_pal_3} provides the primary and 7 bright colors 
of the \href{https://www.caltech.edu/}{California Institute of Technology}, CA, USA.
}
\details{
Caltech's primary orange color is defined as \code{Pantone MS 1585c}  
(for coated and matte print jobs, \code{PMS 151} for uncoated print jobs). 
Use this color for small highlights, rather than large areas. 

Caltech's 7 bright colors provide an opportunity to adjust the temper 
of communication materials from subtle to bold. 
These colors should be used as carefully selected accents 
to the primary, neutral, and deep colors 
(of \code{\link{caltech_pal_1}} and \code{\link{caltech_pal_2}}).
}
\examples{
caltech_pal_3
seecol(caltech_pal_3, main = "Primary and bright colors of Caltech")
demopal(caltech_pal_3, type = 3, seed = 1,  
        main = "Using the primary and bright colors of Caltech")

}
\seealso{
\code{\link{caltech_pal_1}} for Caltech's primary and neutral colors; 
\code{\link{caltech_pal_2}} for Caltech's primary and deep colors; 
\code{\link{seecol}} for viewing and comparing color palettes; 
\code{\link{usecol}} for using color palettes; 
\code{\link{simcol}} for finding similar colors; 
\code{\link{newpal}} for defining new color palettes; 
\code{\link{grepal}} for finding named colors.

Other contributed color palettes: 
\code{\link{caltech_pal_1}},
\code{\link{caltech_pal_2}},
\code{\link{eth_pal_1}},
\code{\link{eth_pal_2}},
\code{\link{eth_pal_3}},
\code{\link{fu_pal_0}},
\code{\link{fu_pal_1}},
\code{\link{fu_pal_2}},
\code{\link{fu_pal_3}},
\code{\link{hu_pal_1}},
\code{\link{hu_pal_2}},
\code{\link{lmu_pal_1}},
\code{\link{lmu_pal_2}},
\code{\link{lmu_pal_3}},
\code{\link{mpg_pal}},
\code{\link{rpi_pal_1}},
\code{\link{rpi_pal_2}},
\code{\link{rpi_pal_3}},
\code{\link{rptu_pal}},
\code{\link{uni_bonn_1}},
\code{\link{uni_bonn_2}},
\code{\link{uni_freiburg_0}},
\code{\link{uni_freiburg_1}},
\code{\link{uni_freiburg_2}},
\code{\link{uni_freiburg_blue}},
\code{\link{uni_freiburg_br}},
\code{\link{uni_freiburg_grey}},
\code{\link{uni_freiburg_info}},
\code{\link{uni_goettingen_1}},
\code{\link{uni_goettingen_2}},
\code{\link{uni_goettingen_3}},
\code{\link{uni_hamburg_1}},
\code{\link{uni_hamburg_2}},
\code{\link{uni_jena_1}},
\code{\link{uni_jena_2}},
\code{\link{uni_kiel_1}},
\code{\link{uni_kiel_2}},
\code{\link{uni_koeln_1}},
\code{\link{uni_koeln_2}},
\code{\link{uni_konstanz_1}},
\code{\link{uni_konstanz_2}},
\code{\link{uni_mannheim_1}},
\code{\link{uni_mannheim_2}},
\code{\link{uni_princeton_0}},
\code{\link{uni_princeton_1}},
\code{\link{uni_princeton_2}},
\code{\link{uni_regensburg_1}},
\code{\link{uni_regensburg_2}},
\code{\link{uni_regensburg_3}},
\code{\link{uni_ulm_1}},
\code{\link{uni_ulm_2}}
}
\author{
\strong{unikn}, 2022-10-28.
}
\concept{contributed color palettes}
\keyword{datasets}
