% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.R
\name{umxSummary}
\alias{umxSummary}
\title{Shows a compact, publication-style, summary of umx models}
\usage{
umxSummary(model, ...)
}
\arguments{
\item{model}{The \code{\link[OpenMx:mxModel]{OpenMx::mxModel()}} whose fit will be reported}

\item{...}{Other parameters to control model summary}
}
\description{
Report the fit of a OpenMx model or specialized model class (such as ACE, CP etc.)
in a compact form suitable for reporting in a journal.

See documentation for RAM models summary here: \code{\link[=umxSummary.MxModel]{umxSummary.MxModel()}}.

View documentation on the ACE model subclass here: \code{\link[=umxSummaryACE]{umxSummaryACE()}}.

View documentation on the ACEv model subclass here: \code{\link[=umxSummaryACEv]{umxSummaryACEv()}}.

View documentation on the IP model subclass here: \code{\link[=umxSummaryIP]{umxSummaryIP()}}.

View documentation on the CP model subclass here: \code{\link[=umxSummaryCP]{umxSummaryCP()}}.

View documentation on the GxE model subclass here: \code{\link[=umxSummaryGxE]{umxSummaryGxE()}}.
}
\seealso{
Other Model Summary and Comparison: 
\code{\link{umx}},
\code{\link{umxCompare}()},
\code{\link{umxEquate}()},
\code{\link{umxMI}()},
\code{\link{umxReduce}()},
\code{\link{umxSetParameters}()}
}
\concept{Model Summary and Comparison}
