% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_time}
\alias{umx_time}
\title{umx_time}
\usage{
umx_time(
  x = NA,
  formatStr = c("simple", "std", "custom \%H \%M \%OS3"),
  tz = "GMT",
  autoRun = TRUE
)
}
\arguments{
\item{x}{A \code{\link[OpenMx:mxModel]{OpenMx::mxModel()}} or list of models for which to display elapsed time, or 'start' or 'stop'}

\item{formatStr}{A format string, defining how to show the time (defaults to human readable)}

\item{tz}{time zone in which the model was executed (defaults to "GMT")}

\item{autoRun}{If TRUE (default), run the model if it appears not to have been.}
}
\value{
\itemize{
\item invisible time string
}
}
\description{
A function to compactly report how long a model took to execute. Comes with some preset styles
User can set the format with C-style string formatting.
}
\details{
The default time format is "simple", which gives only the biggest unit used. i.e., "x seconds" for times under 1 minute.
"std" shows time in the format adopted in OpenMx 2.0 e.g. "Wall clock time (HH:MM:SS.hh): 00:00:01.16"

If a list of models is provided, time deltas will also be reported.

If instead of a model the key word "start" is given in x, a start time will be recorded. "stop" gives the
time since "start" was called (and clears the timer)

If a model has not been run, umx_time will run it for you.
}
\examples{
\dontrun{
require(umx)
umx_time('stop') # alert user stop called when not yet started... 
umx_time('stop')
umx_time('start')
data(demoOneFactor)
latents  = c("G")
manifests = names(demoOneFactor)
myData = mxData(cov(demoOneFactor), type = "cov", numObs=500)
m1 = umxRAM("umx_time_example", data = myData,
	umxPath(from = latents, to = manifests),
	umxPath(var = manifests),
	umxPath(var = latents, fixedAt = 1)
)
umx_time(m1) # report time from mxModel
m2 = umxRun(m1)
umx_time(c(m1, m2)) # print comparison table
umx_time('stop') # report the time since timer last started, and restart
umx_time('stop') # report the time since timer was restarted.
}

}
\references{
\itemize{
\item \url{https://github.com/tbates/umx}
}
}
\seealso{
Other Reporting Functions: 
\code{\link{umx}},
\code{\link{umxAPA}()},
\code{\link{umxFactorScores}()},
\code{\link{umxGetLatents}()},
\code{\link{umxGetManifests}()},
\code{\link{umxGetModel}()},
\code{\link{umxGetParameters}()},
\code{\link{umxParameters}()},
\code{\link{umx_aggregate}()}
}
\concept{Reporting Functions}
