% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/massConvertToNumeric.R
\name{massConvertToNumeric}
\alias{massConvertToNumeric}
\title{Converting many dataframe columns to numeric}
\usage{
massConvertToNumeric(
  dat,
  byFactorLabel = FALSE,
  ignoreCharacter = TRUE,
  stringsAsFactors = FALSE
)
}
\arguments{
\item{dat}{The dataframe with the columns.}

\item{byFactorLabel}{When converting factors, whether to do this
by their label value (\code{TRUE}) or their level value (\code{FALSE}).}

\item{ignoreCharacter}{Whether to convert (\code{FALSE}) or
ignore (\code{TRUE}) character vectors.}

\item{stringsAsFactors}{In the returned dataframe, whether
to return string (character) vectors as factors or not.}
}
\value{
A data.frame.
}
\description{
This function makes it easy to convert many dataframe
columns to numeric.
}
\examples{
### Create a dataset
a <- data.frame(var1 = factor(1:4),
                var2 = as.character(5:6),
                stringsAsFactors=FALSE);

### Ignores var2
b <- ufs::massConvertToNumeric(a);

### Converts var2
c <- ufs::massConvertToNumeric(a,
                               ignoreCharacter = FALSE);
}
