% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rs_classify.R
\name{get_counts}
\alias{get_counts}
\title{counts pixel values according to their classes}
\usage{
get_counts(ids = c(1, 2), position = NULL, imageFiles = NULL,
  buffersize = 1.5, outPrefix = "classified_index_", ext = ".tif",
  path = path_output, dropChars = 0)
}
\arguments{
\item{ids}{numeric. the ids used for the training}

\item{position}{sp. spatialpoint object containing the centre target positions}

\item{imageFiles}{raster* image/classification file}

\item{buffersize}{numeric. radius in meters around position}

\item{outPrefix}{character. out prefix string}

\item{ext}{character. extension}

\item{path}{character. output path}

\item{dropChars}{numeric. number of characters that should be dropped at the end of the filename}
}
\description{
counts pixel values according to their classes
}
\examples{
\dontrun{
##- required packages
 require(uavRst)
 require(link2GI)

##- project root folder
 projRootDir<-tempdir()

##- create subfolders please mind that the pathes are exported as global variables
 paths<-link2GI::initProj(projRootDir = projRootDir,
                          projFolders = c("data/","data/ref/","output/","run/","las/"),
                          global = TRUE,
                          path_prefix = "path_")
##- overide trailing backslash issue
 path_run<-ifelse(Sys.info()["sysname"]=="Windows", sub("/$", "",path_run),path_run)
 setwd(path_run)
 unlink(paste0(path_run,"*"), force = TRUE)

##- get the rgb image, chm and training data
 utils::download.file("https://github.com/gisma/gismaData/raw/master/uavRst/data/tutorial.zip",
                      paste0(path_run,"tutorial_data.zip"))
 unzip(zipfile = paste0(path_run,"tutorial_data.zip"),exdir = path_run)

# read data
 position <- raster::shapefile(paste0(path_run,"position.shp"))
 imageFiles <-Sys.glob(paths = paste0(path_run,"rgb*","tif"))
 imageTrainStack<-lapply(imageFiles, FUN=raster::stack)

## get counts
 df1<-get_counts(position = position,
                      ids = c(100,200),
               imageFiles = imageFiles,
                outPrefix = "",
                      ext = ".tif",
                     path = path_run)
##+}
}
