% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMethods.R, R/printMethods.R,
%   R/quantileResidualTests.R
\name{plot.qrtest}
\alias{plot.qrtest}
\alias{print.qrtest}
\alias{quantile_residual_tests}
\title{Quantile residual tests for GMAR, StMAR , and G-StMAR models}
\usage{
\method{plot}{qrtest}(x, ...)

\method{print}{qrtest}(x, ..., digits = 3)

quantile_residual_tests(
  gsmar,
  lags_ac = c(1, 3, 6, 12),
  lags_ch = lags_ac,
  nsimu = 1,
  print_res = TRUE
)
}
\arguments{
\item{x}{object of class \code{'qrtest'} created with the function \code{quantile_residual_tests}.}

\item{...}{graphical parameters passed to \code{segments} in \code{plot.qrtest}.
Currectly not used in \code{print.qrtest}}

\item{digits}{the number of digits to be print}

\item{gsmar}{object of class \code{'gsmar'} created with the function \code{fitGSMAR} or \code{GSMAR}.}

\item{lags_ac}{a numeric vector of positive integers specifying the lags for which autocorrelation is tested.}

\item{lags_ch}{a numeric vector of positive integers specifying the lags for which conditional heteroscedasticity
is tested.}

\item{nsimu}{a positive integer specifying to how many simulated observations the covariance matrix Omega
(see Kalliovirta (2012)) should be based on. If smaller than data size, then omega will be based on the
given data and not on simulated data. Having the covariance matrix omega based on a large simulated sample
might improve the tests size properties.}

\item{print_res}{a logical argument defining whether the results should be printed or not.}
}
\value{
Returns an object of class \code{'qrtest'} containing the test results in data frames. In the cases
  of autocorrelation and conditional heteroscedasticity tests, the returned object also contains the
  associated individual statistics and their standard errors, discussed in \emph{Kalliovirta (2012)} at
  the pages 369-370.
}
\description{
\code{quantile_residual_tests} performs quantile residual tests for GMAR, StMAR,
 and G-StMAR models, testing normality, autocorrelation, and conditional heteroscedasticity
 of the quantile residuals.
}
\details{
For a correctly specified GSMAR model employing the maximum likelihood estimator, the quantile residuals
  are asymptotically independent with standard normal distribution. They can hence be used in a similar
  manner to conventional Pearson's residuals. For more details about quantile residual based diagnostics,
  and in particular, about the quantile residual tests, see the cited article by \emph{Kalliovirta (2012)}.
}
\section{Methods (by generic)}{
\itemize{
\item \code{plot}: Plot p-values of the autocorrelation and conditional
heteroskedasticity tests.

\item \code{print}: Print method for class 'qrtest' objects
}}

\examples{
\donttest{
## The below examples take approximately 30 seconds to run.

# G-StMAR model with one GMAR type and one StMAR type regime
fit42gs <- fitGSMAR(data=M10Y1Y, p=4, M=c(1, 1), model="G-StMAR",
                    ncalls=1, seeds=4)

# Tests based on the observed data (without simulation procedure) with the
# default lags:
qrt1 <- quantile_residual_tests(fit42gs)

# Tests based on the simulation procedure using sample size 10000 and with
# the lags specified by hand:
set.seed(1)
qrt2 <- quantile_residual_tests(fit42gs, lags_ac=c(1, 6), nsimu=10000)

# GMAR model
fit12 <- fitGSMAR(data=simudata, p=1, M=2, model="GMAR", ncalls=1, seeds=1)
qrt3 <- quantile_residual_tests(fit12, lags_ac=c(1, 5, 10, 15))
}
}
\references{
\itemize{
   \item Galbraith, R., Galbraith, J. 1974. On the inverses of some patterned matrices arising
           in the theory of stationary time series. \emph{Journal of Applied Probability} \strong{11}, 63-71.
   \item Kalliovirta L. (2012) Misspecification tests based on quantile residuals.
           \emph{The Econometrics Journal}, \strong{15}, 358-393.
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2015. Gaussian Mixture Autoregressive model for univariate time series.
           \emph{Journal of Time Series Analysis}, \strong{36}, 247-266.
   \item Meitz M., Preve D., Saikkonen P. 2018. A mixture autoregressive model based on Student's t-distribution.
           arXiv:1805.04010 \strong{[econ.EM]}.
   \item Virolainen S. 2020. A mixture autoregressive model based on Gaussian and Student's t-distribution.	arXiv:2003.05221 [econ.EM].
 }
}
\seealso{
\code{\link{profile_logliks}}, \code{\link{fitGSMAR}}, \code{\link{GSMAR}}, \code{\link{diagnostic_plot}},
 \code{\link{predict.gsmar}}, \code{\link{get_test_Omega}},
}
