% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bal.table.r
\name{bal.table}
\alias{bal.table}
\title{Balance tables for \code{twangRDC}}
\usage{
bal.table(
  x,
  type = "overall",
  n = 10,
  decreasing = TRUE,
  which.sort = "adj",
  include.var = FALSE
)
}
\arguments{
\item{x}{A \code{ps.xgb} object.}

\item{type}{An optional character string requesting if balance should be summarized overall ("overall") or by strata ("strata"). Default: "overall".}

\item{n}{An integer specifying the number of rows to print in the balance table. Default: 10.}

\item{decreasing}{A logical value indicating if the balance table should be sorted in increasing or decreasing order.}

\item{which.sort}{An optional character string indicating if the balance table
should be sorted by the adjusted ("adj") or unadjusted ("unadj") absolute standardized differences. Default: "adj".}

\item{include.var}{A logical value indicating if the variable corresponding the the maximum absolute standardized difference
within strata should be included in the balance table. Only valid when \code{strata=TRUE}. Default: FALSE.}
}
\value{
Returns a table.
}
\description{
\code{bal.table} calculates balance tables from a \code{ps.xgb} object
}
\examples{
# See vignette for examples.
  
}
