% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{tsvGetLines}
\alias{tsvGetLines}
\title{Read matching lines from a tsv file, using a pre-computed index file.}
\usage{
tsvGetLines(filename, indexfile, patterns, findany = TRUE)
}
\arguments{
\item{filename}{The name (and path) of the file containing the data to index.}

\item{indexfile}{The name (and path) of the file to which the index will be written.}

\item{patterns}{A vector of strings containing the string to match against the index entries.  Only
lines with keys that exactly match at least one pattern string are returned.}

\item{findany}{If false, all patterns must be matched. If true (default) at least one pattern must match.}
}
\value{
A string vector whose first element is the first line from data file. Subsequent elements of the
        vector are lines from the data file whose labels match an entry in patterns.
}
\description{
This function reads lines that match the given patterns from a TSV file with the assistance of
a pre-computed index file to the start of each row.
}
\details{
The index file must have been created by tsvGenIndex and the data file must not have changed
since the index file was created.
}
\examples{
datafile = tempfile("data");
df <- data.frame(C1 = c("Foo", "Boing", "The"), C2 = c("Bar", "Boing", "End"));
rownames(df) <- c("R1", "R2", "R3");
write.table(df, file=datafile, sep="\t", quote=FALSE, row.names=TRUE, col.names=TRUE);
indexfile = tempfile("index");
tsvGenIndex (datafile, indexfile);
tsvGetLines (datafile, indexfile, c("R1", "R3"))

}
\seealso{
tsvGenIndex, tscGetData
}
