% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_calendar.R
\name{sim_calendar}
\alias{sim_calendar}
\title{Simulate calendar effects}
\usage{
sim_calendar(
  n,
  which = c("Easter", "Ascension"),
  from = 0,
  to = 0,
  freq = 12,
  effect_size = 3,
  start = "2020-01-01",
  multiplicative = TRUE,
  time_dynamic = 1,
  center = TRUE
)
}
\arguments{
\item{n}{Time series length}

\item{which}{Holidays to be used, functions from timeDate package used}

\item{from}{days before the Holiday to include}

\item{to}{days after the Holiday to include}

\item{freq}{Frequency of the time series}

\item{effect_size}{Mean size of calendar effect}

\item{start}{Start Date of output time series}

\item{multiplicative}{Boolean. Is multiplicative time series model assumed?}

\item{time_dynamic}{Should the calendar effect change over time}

\item{center}{Should calendar variable be center, i.e. mean=0}
}
\value{
The function returns a time series of class \code{xts}
}
\description{
Simulate a time series containing specified calendar effects
}
\details{
If multiplicative is true, the effect size is measured in percentage. If is not true, the effect size is unit less and thus adopts the unit of the time series the calendars are added to.
The time_dynamic parameter controls the change of the calendar effect. The effect of the previous year is multiplied by the time_dynamic factor.
}
\examples{
plot(sim_calendar(60, from=0, to=4, freq=12))
}
\references{
Ollech, D. (2021). Seasonal adjustment of daily time series. Journal of Time Series Econometrics. \doi{10.1515/jtse-2020-0028}
}
\author{
Daniel Ollech
}
