% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_fil_kalman.R
\name{ts_fil_kalman}
\alias{ts_fil_kalman}
\title{Kalman Filter}
\usage{
ts_fil_kalman(H = 0.1, Q = 1)
}
\arguments{
\item{H}{variance or covariance matrix of the measurement noise. This noise pertains to the relationship between the true system state and actual observations. Measurement noise is added to the measurement equation to account for uncertainties or errors associated with real observations. The higher this value, the higher the level of uncertainty in the observations.}

\item{Q}{variance or covariance matrix of the process noise. This noise follows a zero-mean Gaussian distribution. It is added to the equation to account for uncertainties or unmodeled disturbances in the state evolution. The higher this value, the greater the uncertainty in the state transition process.}
}
\value{
a \code{ts_fil_kalman} object.
}
\description{
The Kalman filter is an estimation algorithm that produces estimates of certain variables based on imprecise measurements to provide a prediction of the future state of the system.
It wraps KFAS package.
}
\examples{
# time series with noise
library(daltoolbox)
data(sin_data)
sin_data$y[9] <- 2*sin_data$y[9]

# filter
filter <- ts_fil_kalman()
filter <- fit(filter, sin_data$y)
y <- transform(filter, sin_data$y)

# plot
plot_ts_pred(y=sin_data$y, yadj=y)
}
