% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ensembling-pipes.R
\name{model_weighting}
\alias{model_weighting}
\title{Model weighting}
\usage{
model_weighting(x, trans = "softmax", ...)
}
\arguments{
\item{x}{A object describing the loss of each base model}

\item{trans}{Character value describing the transformation type.
The available options are \strong{softmax}, \strong{linear} and
\strong{erfc}. The softmax and erfc provide a non-linear transformation
where the weights decay exponentially as the relative loss of a given model
increases (with respect to all available models). The linear transformation
is a simple normalization of values using the max-min method.}

\item{...}{Further arguments to \code{normalize} and
\code{proportion} functions \(na.rm = TRUE\)}
}
\value{
An object describing the weights of models
}
\description{
This is an utility function that takes the raw error of
models and scales them into a 0-1 range according to one
of three strategies:
}
\details{
\describe{
\item{erfc}{using the complementary Gaussian error function}
\item{softmax}{using a softmax function}
\item{linear}{A simple normalization using max-min method}
}

These tranformations culminate into the
final weights of the models.
}
\seealso{
Other weighting base models: \code{\link{EMASE}},
  \code{\link{build_committee}},
  \code{\link{get_top_models}},
  \code{\link{model_recent_performance}},
  \code{\link{select_best}}
}
