% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdqr.R
\name{dghst}
\alias{dghst}
\alias{rghst}
\alias{pghst}
\alias{qghst}
\title{Generalized Hyperbolic Skewed Student Distribution}
\usage{
dghst(x, mu = 0, sigma = 1, skew = 1, shape = 8, log = FALSE)

rghst(n, mu = 0, sigma = 1, skew = 1, shape = 8)

pghst(
  q,
  mu = 0,
  sigma = 1,
  skew = 1,
  shape = 8,
  lower_tail = TRUE,
  log = FALSE
)

qghst(
  p,
  mu = 0,
  sigma = 1,
  skew = 1,
  shape = 8,
  lower_tail = TRUE,
  log = FALSE
)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{mu}{mean.}

\item{sigma}{standard deviation.}

\item{skew}{skew parameter.}

\item{shape}{shape parameter.}

\item{log}{(logical) if TRUE, probabilities p are given as log(p).}

\item{n}{Number of observations.}

\item{lower_tail}{if TRUE (default), probabilities are \eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}
}
\value{
d gives the density, p gives the distribution function, q gives the quantile function
and r generates random deviates. Output depends on x or q length, or n for the random number
generator.
}
\description{
Density, distribution, quantile function and random number
generation for the generalized hyperbolic skew student distribution parameterized in 
terms of mean, standard deviation, skew and shape parameters.
}
