% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rrod.test.R
\name{rrod.test}
\alias{rrod.test}
\alias{rrod.test.default}
\alias{rrod.test.formula}
\title{Robust Rank-Order Distributional Test}
\usage{
rrod.test(x, ...)

\method{rrod.test}{default}(x, y, alternative = c("two.sided", "less",
  "greater"), ...)

\method{rrod.test}{formula}(formula, data, subset, na.action, ...)
}
\arguments{
\item{x}{a vector of data values.}

\item{\dots}{further arguments to be passed to or from methods.}

\item{y}{an optional numeric vector of data values.}

\item{alternative}{the alternative hypothesis. Defaults to \code{"two.sided"}.}

\item{formula}{a formula of the form \code{response ~ group} where
\code{response} gives the data values and \code{group} a vector or
factor of the corresponding groups.}

\item{data}{an optional matrix or data frame (or similar: see
\code{\link{model.frame}}) containing the variables in the
formula \code{formula}.  By default the variables are taken from
\code{environment(formula)}.}

\item{subset}{an optional vector specifying a 
subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when
the data contain \code{NA}s.  Defaults to \code{getOption("na.action")}.}
}
\value{
A list with class \code{"htest"}.
}
\description{
Performs Fligner-Pollicello robust rank-order distributional test
for location.
}
\details{
The non-parametric RROD two-sample test can be used to test
for differences in location, whereas it does not assume variance
homogeneity.

Let \eqn{X} and \eqn{Y} denote two samples with sizes \eqn{n_x}{nx} and \eqn{n_y}{ny}
of a continuous variable.First, the combined sample is transformed
into ranks in increasing order.
Let \eqn{S_{xi}}{Sx} and \eqn{S_{yj}}{Sy} denote the counts of \eqn{Y} \eqn{(X)}
values having a lower rank than \eqn{x_i} \eqn{(y_j)}. The mean counts are:

\deqn{\bar{S}_x = \sum_{i=1}^{n_x} S_{xi} / n_x}{%%
Sx = sum(Sxi) / nx}

\deqn{\bar{S}_y = \sum_{j=1}^{n_y} S_{yj} / n_y}{%%
Sy = sum(Syi) / ny}

The variances are:
\deqn{s^2_{Sx} = \sum_{i=1}^{n_x} \left( S_{xi} - \bar{S}_x \right)^2}{%%
sSxsq = sum((Sxi - Sx)^2)}

\deqn{s^2_{Sy} = \sum_{j=1}^{n_y} \left( S_{yj} - \bar{S}_y \right)^2}{%%
sSysq = sum((Syj - Sy)^2)}

The test statistic is:
\deqn{
z = \frac{1}{2}~
\frac{n_x \bar{S}_x - n_y \bar{S}_y}
{\left( \bar{S}_x \bar{S}_y + s^2_{Sx} + s^2_{Sy} \right)^{1/2}}}{%%
z = 1/2 * (nx * Sx - ny * Sy) / (Sx * Sy + sSxsq + sSysq)^0.5}

The two samples have significantly different location parameters,
if \eqn{|z| > z_{1-\alpha/2}}{|z| > z(1-alpha/2)}.
The function calculates the \eqn{p}-values of the null hypothesis
for the selected alternative than can be \code{"two.sided"}, \code{"greater"}
or \code{"less"}.
}
\examples{
## Two-sample test.
## Hollander & Wolfe (1973), 69f.
## Permeability constants of the human chorioamnion (a placental
##  membrane) at term (x) and between 12 to 26 weeks gestational
##  age (y).  The alternative of interest is greater permeability
##  of the human chorioamnion for the term pregnancy.
x <- c(0.80, 0.83, 1.89, 1.04, 1.45, 1.38, 1.91, 1.64, 0.73, 1.46)
y <- c(1.15, 0.88, 0.90, 0.74, 1.21)
rrod.test(x, y, alternative = "g")

## Formula interface.
boxplot(Ozone ~ Month, data = airquality)
rrod.test(Ozone ~ Month, data = airquality,
            subset = Month \%in\% c(5, 8)) 
}
\references{
Fligner, M. A., Pollicello, G. E. III. (1981), Robust Rank Procedures for 
the Behrens-Fisher Problem, \emph{Journal of the 
American Statistical Association}, 76, 162--168.

Lanzante, J. R. (1996), Resistant, robust and non-parametric
techniques for the analysis of climate data: Theory and examples,
including applications to historical radiosonde station data,
\emph{Int. J. Clim.}, 16, 1197--1226.

Siegel, S. and Castellan, N. (1988),
\emph{Nonparametric Statistics For The Behavioural Sciences},
New York: McCraw-Hill.
}
\seealso{
\code{\link[stats]{wilcox.test}}
}
\keyword{htest}
\keyword{nonparametric}
