% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set-methods.R
\name{rmOtherSlt}
\alias{rmOtherSlt}
\title{Remove a user-defined slot}
\usage{
rmOtherSlt(tree, slt_nm)
}
\arguments{
\item{tree}{\code{TreeMan} object}

\item{slt_nm}{name of slot to be removed}
}
\description{
Returns a tree with a user-defined tree slot removed.
}
\details{
A user can specify a new slot using the \code{setNdSlt()} function
or upon reading a tree. This can be removed using this function by specifying
the name of the slot to be removed.
}
\examples{
library(treeman)
tree <- randTree(10)
vals <- runif(min=0, max=1, n=tree['nall'])
tree <- setNdsOther(tree, tree['all'], vals, 'confidence')
tree <- updateSlts(tree)
summary(tree)
tree <- rmOtherSlt(tree, 'confidence')
tree <- updateSlts(tree)
summary(tree)
}
\seealso{
\code{\link{setNdOther}}, \code{\link{setNdsOther}},
\url{https://github.com/DomBennett/treeman/wiki/set-methods}
}
