% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc-methods.R
\name{calcPrtFrPrp}
\alias{calcPrtFrPrp}
\title{Calculate evolutionary distinctness for part of tree}
\usage{
calcPrtFrPrp(tree, tids, ignr = NULL, progress = "none")
}
\arguments{
\item{tree}{\code{TreeMan} object}

\item{tids}{tip IDs}

\item{ignr}{tips to ignore in calculation}

\item{progress}{name of the progress bar to use, see \code{\link{create_progress_bar}}}
}
\description{
Returns the evolutationary distinctness of ids using the fair proportion metric.
}
\details{
Extension of \code{calcFrPrp()} but with ignore argument.
Use \code{ignr} to ignore certain tips from calculation. For example, if any of tips
are extinct you may wish to ignore these.
}
\examples{
library(treeman)
tree <- randTree(10)
calcPrtFrPrp(tree, c('t1','t3'), ignr='t2')
}
\references{
Isaac, N.J.B., Turvey, S.T., Collen, B., Waterman, C. and Baillie, J.E.M. (2007). 
 Mammals on the EDGE: conservation priorities based on threat and phylogeny. PLoS ONE, 2, e296.
}
\seealso{
\code{\link{calcFrPrp}}
\url{https://github.com/DomBennett/treeman/wiki/calc-methods}
}
