% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-spcl-methods.R
\name{getCnnctdNds}
\alias{getCnnctdNds}
\title{Get all nodes connected by given tips}
\usage{
getCnnctdNds(tree, tids)
}
\arguments{
\item{tree}{\code{TreeMan} object}

\item{tids}{vector of tip IDs}
}
\description{
Return a vector of IDs of all nodes that are connected to tip IDs given.
}
\details{
Returns a vector. This function is the basis for \code{calcPhyDv()}, it determines
the unique set of nodes connected for a set of tips.
}
\examples{
library(treeman)
tree <- randTree(10)
cnntdnds <- getCnnctdNds(tree, c('t1', 't2'))
}
\seealso{
\code{\link{getUnqNds}}, \code{\link{calcFrPrp}},
\code{\link{calcPhyDv}}
}
