% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip-methods.R
\name{addTip}
\alias{addTip}
\title{Add tip to a tree}
\usage{
addTip(tree, tid, sid, start, end, pid = paste0("p_", tid))
}
\arguments{
\item{tree}{\code{TreeMan} object}

\item{tid}{tip ID}

\item{sid}{ID of node that will become new tip's sister}

\item{start}{start time}

\item{end}{end time}

\item{pid}{parent ID (default is 'p_' + tid)}
}
\description{
Returns a tree with a tip ID added
}
\details{
User must provide a new tip ID, the ID of a node
which will become the new tip's sister, a start time point to
specify when the new branch will start in time and, an end time point
(0 for extant tips).
}
\examples{
library(treeman)
tree <- randTree(10)
# add a new tip to the branch preceding t1
# calculate the span and find a point in that time frame for start
t1_spn <- getSpnAge(tree, 't1')
start <- runif(max=t1_spn[1, 'start'], min=t1_spn[1, 'end'], n=1)
end <- runif(max=start, min=0, n=1)
tree <- addTip(tree, tid='t11', sid='t1', start=start, end=end)
}
\seealso{
\code{\link{rmTip}}, 
\url{https://github.com/DomBennett/treeman/wiki/manip-methods}
}

