% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_multilocus.R
\name{collapse_locus_subtree}
\alias{collapse_locus_subtree}
\title{Collapse a clade into a single tip}
\usage{
collapse_locus_subtree(list_of_subtrees, locus_to_collapse)
}
\arguments{
\item{list_of_subtrees}{a list of type `multiPhylo`}

\item{locus_to_collapse}{a subtree found within a subst of `list_of_subtrees`}
}
\value{
multiPhy (list of trees) with the subtree in question collapse
}
\description{
Collapse a clade into a single tip
}
\details{
Takes a clade as input and collapses that clade to one tip
in all trees in `list_of_subtrees`.
}
\examples{
lambda <- 1.0
mu <- 0.2
nt <- 10
trees <- sim_sptree_bdp(sbr = lambda, sdr = mu, numbsim = 1, n_tips = nt)
subtrees_of_trees <- ape::subtrees(trees[[1]])
st_of_interest <- subtrees_of_trees[[1]]
collapse_st_of_interest <- collapse_locus_subtree(trees, st_of_interest)
}
