% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiPlotSP.R
\name{multiPlotSP}
\alias{multiPlotSP}
\title{Plots several single-phase transport profiles overlayed}
\usage{
multiPlotSP(trans, phase = "strip", trend = NULL, legend = FALSE,
  xlab = "Time (h)", ylab = expression(Phi), xlim = NULL, ylim = NULL,
  xbreaks = NULL, ybreaks = NULL, size = 3, plot = TRUE, shape = 15,
  bw = FALSE, arw = FALSE, arw.pos = NULL, arw.txt = NULL,
  txt.pos = NULL, txt.size = NULL)
}
\arguments{
\item{trans}{List of data frames with the complete transport
information of interest species. Must be generated
using \code{\link{conc2frac}}. This is the only
non-optional parameter.}

\item{phase}{Phase to be represented in the plot: \code{'strip'},
the default, or \code{'feed'}.}

\item{trend}{List of Non-linear regression models of the main species
transport profil. Generated using \code{\link{transTrend}}.}

\item{legend}{Logical. If \code{FALSE}, the default, the legend is not
included.}

\item{xlab}{Label to be used for x axis. Text and expression allowed.}

\item{ylab}{Label to be used for y axis. Text and expression allowed.}

\item{xlim}{Numeric vector of limits for X-axis.}

\item{ylim}{Numeric vector of limits for X-axis.}

\item{xbreaks}{Numeric vector of x-axis breaks.}

\item{ybreaks}{Numeric vector of x-axis breaks.}

\item{size}{Size used for points in the plot.}

\item{plot}{Logical. If \code{TRUE}, the default, the plot is printed
in the current graphical device.}

\item{shape}{Shape to use in the points to be plotted.}

\item{bw}{Logical, if \code{FALSE}, the default, a color version of
the plot is given. If a black and white version is
required, it must be set to \code{TRUE}.}

\item{arw}{Logical default to \code{FALSE}. If \code{TRUE}, a vertical
arrow is drawn in the plot. Its use is recommended when
a trend along the profiles is to be indicated.}

\item{arw.pos}{Numeric vector of the coordinates of the arrow if
\code{arw = TRUE}. The format is (x0, x1, y0, y1)}

\item{arw.txt}{Text to be (optionally) printed alongside the arrow.}

\item{txt.pos}{Numeric vector of the position of the center of the text
provided in \code{arw.txt}. The format is (x, y). If not
provided, the text is located close to the arrow but a
little alignment could be required.}

\item{txt.size}{Size of the text accompanying the arrow.}
}
\value{
Plot with the overlayed transport profiles for a single phase
}
\description{
Given a list of several complete transport data, the function overlays the
transport profiles in a defined phase. The function is useful in membrane
reuse experiments as transport profile deterioration is easily visualized.
}
\details{
Most \code{transmem} graphical representations are made using the package
\code{ggplot2} so the function returns a ggplot2 object that can be
assigned to a variable for further modification.
}
\examples{
  data(reusecycles)
  # First step is to get trend lines for each cycle:
  trend <- list()
  for (i in 1:length(reusecycles)) {
    trend[[i]] <- transTrend(trans = reusecycles[[i]])
  }
  # Default plot using colors:
  multiPlotSP(trans = reusecycles, trend = trend, legend = TRUE)

  # Black and white plot including an arrow:
  multiPlotSP(trans = reusecycles, trend = trend, legend = TRUE, bw = TRUE,
              arw = TRUE, arw.pos = c(6.1, 6.1, 0.8, 0.6),
              arw.txt = 'Cycle', txt.pos = c(6.15, 0.7))
}
\author{
Cristhian Paredes, \email{craparedesca@unal.edu.co}

Eduardo Rodriguez de San Miguel, \email{erdsmg@unam.mx}
}
