% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xpssElseIf.R
\name{xpssElseIf}
\alias{xpssElseIf}
\title{Creates a subcondition within a DO IF - END IF subset}
\usage{
xpssElseIf(x, cond = NULL)
}
\arguments{
\item{x}{a (non-empty) data.frame or input data of class \code{"xpssFrame"}.}

\item{cond}{logical expression indicating the condition for subsetting.}
}
\value{
Output is a subset of the actual dataset under the condition of the logical expression.
}
\description{
R implementation of the SPSS \code{DO IF} argument.
}
\details{
After using \code{xpssDoIf} every following subset command will be initiated by \code{xpssElseIf}. \code{xpssElseIf} is working similar to \code{xpssDoIf}. Both functions select cases for analysis based on one or more logical conditions. The conditions to select cases are specified in a logical expression. These logical expressions can contain relational operators, logical operators and arithmetic operations. \code{xpssElseIf} creates a subset of the actual dataset, without deleting the excluded variables, respectively without deleting the excluded values.\cr \cr

The data is subsetted until \code{\link{xpssEndIf}} restores the excluded data. All changes made at the subsetted data will be taken over, the excluded data will remain untouched! As noted before, those cases are not actually deleted and will be available after \code{xpssEndIf} restores the excluded data. \cr \cr

In a different way to SPSS. Not only data management functions like \code{xpssRecode} can be used within \code{xpssElseIf}, it is possible to use statistical and descriptiv functions like \code{xpssFrequencies} too. \cr \cr
 \strong{NOTE:} For temporary case selection, specify \code{\link{xpssTemporary}} before \code{xpssDoIf}.
}
\examples{
data(fromXPSS)
temp <- xpssDoIf(x=fromXPSS, cond = "V3 == 1")
temp <- xpssRecode(x=temp,variables="V5",rec="lo:78 = 1; else = 2")
temp <- xpssElseIf(x=temp, cond = "V3 == 1")
temp <- xpssRecode(x=temp,variables="V5",rec="lo:78 = 11; else = 22")
temp <- xpssEndIf(x=temp)
}
\author{
Bastian Wiessner
}
\seealso{
Related Functions \code{\link{xpssDoIf}}, \code{\link{xpssEndIf}}, \code{\link{xpssFilter}}, \code{\link{xpssSelectIf}}, \code{\link{xpssTemporary}}
}

