% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xpssCount.R
\name{xpssCount}
\alias{xpssCount}
\title{Counts frequencies of specific observations}
\usage{
xpssCount(x, variables, count)
}
\arguments{
\item{x}{a (non-empty) data.frame or input data of class \code{xpssFrame}.}

\item{variables}{atomic character or character vector with the name of the variables.}

\item{count}{atomic character or atomic numeric pattern.}
}
\value{
A vector of the same length as x.
}
\description{
R implementation of the SPSS \code{$COUNT} system variable.
}
\details{
Count displays the frequencies of observations matching the count statement.
}
\examples{
data(fromXPSS)

xpssCount(x=fromXPSS,
   variables = "V1", count=list(exact="Nissan"))

xpssCount(x=fromXPSS,
   variables = "V5", count=list(exact=2))

xpssCount(fromXPSS,
   variables = span(fromXPSS, from = "V5",
                             to = "V7_2"),
                   count = list(from = "lo",
                                  to = 100))
}
\author{
Bastian Wiessner
}
\seealso{
Related Functions \code{\link{xpssAny}} \code{\link{\%in\%}} \code{\link{is.element}}
}

