% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xpssComputeDates.R
\name{computeXdate_month}
\alias{computeXdate_month}
\title{Extracts the month component on basis of a given date}
\usage{
computeXdate_month(x=NULL)
}
\arguments{
\item{x}{atomic object of class \code{character, POSIXlt  or  POSIXt} holding date data.}
}
\value{
Returns a character string with the month component.
}
\description{
R Implementation of the SPSS \code{XDATE.MINUTE} Function. \code{computeXdate_month} is a helper function for xpssCompute.
}
\details{
computeXdate_month extract the month component out of the date string, the other date and time componentes will be omitted.
}
\examples{
xpssCompute(x="2015-02-15 20:11:20", fun="computeXdate_month")
xpssCompute(x="2022-10-20 21:22:12", fun="computeXdate_month")
}
\author{
Bastian Wiessner
}
\seealso{
\code{\link{computeXdate_date}} \code{\link{computeDate_wkyr}}
}
\keyword{internal}

