% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trampoline.R
\name{trm_return}
\alias{trm_return}
\title{Flag a return value}
\usage{
trm_return(x)
}
\arguments{
\item{x}{A value to be returned at the end of all recursions}
}
\value{
\code{x} with added class attribute 'trampoline_return'
}
\description{
Wrap a return value in your recursive function with \code{trm_return()}
to have it passed along and returned by your final recursion.
}
\examples{
trampoline(factorial(13),
           factorial = function(n) {
             if(n <= 1) {
               return(trm_return(1))
             }
             val <- yield(factorial(n - 1))
             return(val * n)
           })
}
