% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{ranef.LmME}
\alias{ranef.LmME}
\title{Extract the conditional modes of random effects of an LmME model}
\usage{
\method{ranef}{LmME}(object, as.lm = FALSE, ...)
}
\arguments{
\item{object}{A fitted LmME object.}

\item{as.lm}{If TRUE, return the transformed conditional modes as in a
normal linear mixed effects model.}

\item{...}{Optional parameters passed to \code{ranef.tramME}.}
}
\value{
A numeric vector or a \code{ranef.tramME} object depending on the inputs.
}
\description{
The \code{condVar} option is not implemented for \code{ranef.LmME}.
Setting \code{raw=TURE} will return the raw random effects estimates from
the transformation model parametrization.
}
\examples{
data("sleepstudy", package = "lme4")
fit <- LmME(Reaction ~ Days + (Days | Subject), data = sleepstudy)
ranef(fit, raw = TRUE) ## transformation model parametrization!
ranef(fit, as.lm = TRUE)
}
