% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotMeanTraj.R
\name{plotMeanTraj}
\alias{plotMeanTraj}
\title{Plot Mean Trajectory}
\usage{
plotMeanTraj(x, clust.num = NULL, ...)
}
\arguments{
\item{x}{\code{traj} object.}

\item{clust.num}{Integer indicating the cluster number to plot.\code{NULL} to print all clusters. Defaults to
\code{NULL}.}

\item{...}{Arguments to be passed to plot.}
}
\description{
Plot cluster-specific mean trajectory for one or all clusters provided by a \code{traj} object.
}
\details{
The function plots cluster specific mean trajectory calculated at each time point. By setting the \code{clust.num} argument to an integer corresponding to a cluster number, one can plot the mean trajectory of that cluster only. Any other plotting arguments can be added to the function.
}
\examples{
\dontrun{
# Setup data 
data = example.data$data

# Run step1measures, step2factors and step3clusters with a predetermined number of clusters
s1 = step1measures(data, ID=TRUE)
s2 = step2factors(s1)
s3.4clusters = step3clusters(s2, nclust = 4)

# Plot mean trajectories
plotMeanTraj(s3.4clusters)
}
}
\author{
Marie-Pierre Sylvestre, Dan Vatnik

marie-pierre.sylvestre@umontreal.ca
}
