% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Generics.R, R/PlotWrapper.R,
%   R/accessor-methods.R
\docType{methods}
\name{hasLegend}
\alias{hasLegend}
\alias{hasLegend,PlotFeatureSet-method}
\alias{hasLegend,ggplot-method}
\alias{hasLegend,trellis-method}
\alias{hasLegend,gTree-method}
\alias{hasLegend,PlotFeatureSet-method}
\title{Accessor method for the legend indicator (slot "haslegend") of the plot object.}
\usage{
hasLegend(object)

\S4method{hasLegend}{PlotFeatureSet}(object)

\S4method{hasLegend}{ggplot}(object)

\S4method{hasLegend}{trellis}(object)

\S4method{hasLegend}{gTree}(object)

\S4method{hasLegend}{PlotFeatureSet}(object)
}
\arguments{
\item{object}{An object of class PlotFeatureSet, GGplotFeatureSet, TrellisFeatureSet, ggplot, or trellis.}
}
\value{
A boolean indicating whether or not a legend is displayed in the plot.
}
\description{
Get whether or not a plot or PlotFeatureSet.
}
\examples{
library(ggplot2)
mt = datasets::mtcars
plt = qplot(mt$mpg, mt$cyl)
fs = makeFeatureSet(plt)
hasLegend(fs)
}
